﻿Imports System.Net.Sockets

Module MdlTcpClient

    '****************************************************************************
    ' Function name
    '   PutTcpIpClient
    ' Argument
    '   client : TCP/IP client.
    '   dt : transmission command. (string)
    ' Explanation
    '   The transmission command of argument is transmitted to client by TCP/IP.
    ' Return value
    '   0          : Normal
    '   0 Excluding: Error number
    '****************************************************************************
    Public Function PutTcpIpClient(ByRef client As TcpClient, ByVal dt As String) As Integer
        Try
            Dim stream As NetworkStream = client.GetStream()
            Dim send_buf() As Byte = System.Text.Encoding.ASCII.GetBytes(dt + ControlChars.CrLf + ControlChars.CrLf)
            stream.Write(send_buf, 0, send_buf.Length)
            PutTcpIpClient = 0
        Catch ex As Exception
            PutTcpIpClient = 1
        End Try
    End Function


    '****************************************************************************
    ' Function name
    '   QeryTcpIpClient
    ' Argument
    '   client : TCP/IP client.
    '   dt : transmission command (character string)
    '   QryDt : Receive data area to transmission command (character string)
    ' Explanation
    '   The transmission command of argument is transmitted to client by TCP/IP.
    '   The data reply to QryDt is stored and returned. 
    ' Return value
    '   0          : Normal
    '   0 Excluding: Error number
    '****************************************************************************
    Public Function QeryTcpIpClient(ByRef client As TcpClient, ByVal dt As String, ByRef QryDt As String) As Integer
        Dim n As Integer
        Try
            Dim stream As NetworkStream = client.GetStream()
            Dim send_buf() As Byte = System.Text.Encoding.ASCII.GetBytes(dt + ControlChars.CrLf + ControlChars.CrLf)
            stream.Write(send_buf, 0, send_buf.Length)
            Dim read_buf(4006) As Byte
            n = stream.Read(read_buf, 0, read_buf.Length)
            QryDt = System.Text.Encoding.Default.GetString(read_buf)
            n = InStr(QryDt, vbCr, vbBinaryCompare)
            QryDt = Mid(QryDt, 1, n)
            QeryTcpIpClient = 0
        Catch ex As Exception
            QeryTcpIpClient = 1
        End Try

    End Function

    Public Function GetTcpIpClient(ByRef client As TcpClient, ByRef QryDt As String) As Integer
        Dim n As Integer
        Try
            Dim stream As NetworkStream = client.GetStream()
            Dim read_buf(4006) As Byte
            n = stream.Read(read_buf, 0, read_buf.Length)
            QryDt = System.Text.Encoding.Default.GetString(read_buf)
            n = InStr(QryDt, vbCr, vbBinaryCompare)
            QryDt = Mid(QryDt, 1, n)
            GetTcpIpClient = 0
        Catch ex As Exception
            GetTcpIpClient = 1
        End Try
    End Function

    '
    ' TCP/IP Client open
    '
    Public Function OpenTcpIpClient(ByRef client As TcpClient, ByVal strIpAdrs As String, ByVal strPortNo As String) As Integer
        Try
            OpenTcpIpClient = 0
            client.Connect(strIpAdrs, strPortNo)            ' Sets IP Address and port no.
            Dim steam As NetworkStream = client.GetStream() ' TCP Connects to client port
        Catch ex As Exception
            OpenTcpIpClient = 1
        End Try

    End Function

    '
    'TCP/IP Client close
    '
    Public Sub CloseTcpIpClient(ByRef client As TcpClient)

        If client.Connected = True Then
            client.Close()
        End If

    End Sub

End Module
